<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Consulta entradas de almacén</title>

    <!-- Estilos CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/v/dt/jszip-2.5.0/pdfmake-0.1.18/dt-1.10.12/af-2.1.2/b-1.2.2/b-colvis-1.2.2/b-flash-1.2.2/b-html5-1.2.2/b-print-1.2.2/cr-1.3.2/fc-3.2.2/fh-3.1.2/kt-2.1.3/r-2.1.0/rr-1.1.2/sc-1.4.2/se-1.2.0/datatables.min.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
</head>

<body>

<section class="content-header">
    <h1><i class="fa fa-sign-in icon-title"></i> Consulta entradas de almacén</h1>
</section>

<section class="content">
    <div class="row">
        <div class="col-md-12">
            <?php
            // Alertas
            $alertMessages = [
                "",
                "<div class='alert alert-success alert-dismissable'>
                    <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
                    <h4><i class='icon fa fa-check-circle'></i> Éxito!</h4>
                    Datos de productos han sido registrados correctamente.
                </div>",
                "<div class='alert alert-danger alert-dismissable'>
                    <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
                    <h4><i class='icon fa fa-warning'></i> Error!</h4>
                    Favor de seleccionar registros.
                </div>",
                "<div class='alert alert-success alert-dismissable'>
                    <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
                    <h4><i class='icon fa fa-check-circle'></i> Éxito!</h4>
                    Registros cancelados correctamente.
                </div>",
                "<div class='alert alert-danger alert-dismissable'>
                    <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
                    <h4><i class='icon fa fa-warning'></i> Error!</h4>
                    El folio ya se encuentra cancelado: " . (!empty($_GET['folio']) ? $_GET['folio'] : '') . "
                </div>"
            ];

            if (isset($_GET['alert']) && isset($alertMessages[$_GET['alert']])) {
                echo $alertMessages[$_GET['alert']];
            }
            ?>
            
            <div id="alert-msj"></div>

            <div class="box box-primary">
                <div class="box-body">
                    <div class="table-responsive">
                        <table id="dataTables" class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr>
                                    <th class="center" style="color: #ffffff; background-color: #4682B4">ID</th>
                                    <th class="center" style="color: #ffffff; background-color: #4682B4">FOLIO</th>
                                    <th class="center" style="color: #ffffff; background-color: #4682B4">GENERA</th>
                                    <th class="center" style="color: #ffffff; background-color: #4682B4">RECIBE</th>
                                    <th class="center" style="color: #ffffff; background-color: #4682B4">TIPO</th>
                                    <th class="center" style="color: #ffffff; background-color: #4682B4">MOTIVO CANCELACION</th>
                                    <th class="center" style="color: #ffffff; background-color: #4682B4">FECHA</th>
                                    <th class="center" style="color: #ffffff; background-color: #4682B4">STATUS</th>
                                    <th class="center" style="color: #ffffff; background-color: #4682B4">ACCIONES</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $query = mysqli_query($mysqli, "
                                   SELECT
                                            MAX(a.id) AS id,
                                            MAX(a.serie) AS serie,
                                            a.folio,
                                            MAX(a.created_date) AS created_date,
                                            MAX(u.name_user) AS name_user,
                                            CASE
                                                WHEN MAX(b.tipo_transaccion) = 'Salida' THEN 'SALIDA'
                                                WHEN MAX(b.tipo_transaccion) = 'Entrada' THEN 'ENTRADA'
                                                ELSE ''
                                            END AS Tipo,
                                            MAX(b.observaciones) AS observaciones,
                                            CASE
                                                WHEN MAX(a.status) = 'C' THEN 'CANCELADA'
                                                WHEN MAX(a.status) = 'A' THEN 'ACTIVA'
                                                ELSE 'SURTIDA'
                                            END AS status,
                                            MAX(a.txtCorreo) AS txtCorreo,
                                            MAX(a.txtCancel) AS txtCancel,
                                            MAX(c.nombre) AS nombre
                                        FROM
                                            transaccion_medicamentos_enc AS a
                                            JOIN transaccion_medicamentos AS b ON b.idenc = a.id
                                            JOIN usuarios AS u ON b.created_user = u.id_user
                                            JOIN correos AS c ON c.tipo = a.txtCorreo
                                        WHERE
                                            tipo_transaccion = 'Entrada'
                                        GROUP BY
                                            a.folio
                                        ORDER BY
                                            MAX(a.id) DESC;")
                                    or die('error ' . mysqli_error($mysqli));

                                while ($data = mysqli_fetch_assoc($query)) {
                                    $folio = $data['folio'];
                                    $fecha = $data['created_date'];
                                    $exp = explode('-', $fecha);
                                    $fecha2 = $exp[2] . "-" . $exp[1] . "-" . $exp[0];
                                    $sta = $data['status'];

                                    echo "<tr>
                                              <td width='10' class='center'>$data[id]</td>
                                              <td width='10' class='center'>$folio_perfil - $data[folio]</td>
                                              <td width='10' class='center'>$data[name_user]</td>
                                              <td width='80' class='center'>$data[nombre] $data[txtCorreo]</td>
                                              <td width='80' class='center'>$data[Tipo]</td>
                                              <td width='80' class='center'>$data[txtCancel]</td>
                                              <td width='30' class='center'>$fecha</td>
                                              <td width='20' class='center'>$sta</td>
                                              <td width='30' class='center'>
                                                 <a href='modules/trade/consulta_entradas_enc/print.php?id=$data[id]' class='btn-circle' target='_blank'><i class='glyphicon glyphicon-print' data-toggle='tooltip' title='Reimprimir'></i></a>
                                              </td>
                                          </tr>";
                                }
                                ?>
                            </tbody>
                        </table>
                    </div><!-- /.table-responsive -->
                </div><!-- /.box-body -->
            </div><!-- /.box -->
        </div><!--/.col -->
    </div>   <!-- /.row -->
</section><!-- /.content -->

<!-- JavaScript -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://cdn.datatables.net/v/dt/jszip-2.5.0/pdfmake-0.1.18/dt-1.10.12/af-2.1.2/b-1.2.2/b-colvis-1.2.2/b-flash-1.2.2/b-html5-1.2.2/b-print-1.2.2/cr-1.3.2/fc-3.2.2/fh-3.1.2/kt-2.1.3/r-2.1.0/rr-1.1.2/sc-1.4.2/se-1.2.0/datatables.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>

<script>
    $(document).ready(function () {
        // Inicialización de DataTables
        $("table").dataTable({
            "order": [[2, "desc"]],
            "rowCallback": function (row, data) {
                if (data[7] == "ACTIVA") {
                    $($(row).find("td")[7]).css("background-color", "Beige");
                } else {
                    $($(row).find("td")[7]).css("background-color", "Pink");
                }
            }
        });
    });
</script>

<script>
    $('#dataTables2').dataTable({
        "drawCallback": function (settings) {
            $('ul.pagination').addClass("pagination-sm");
        }
    });
</script>

</body>
</html>
