<?php
session_start();

require_once "../../../config/database.php";

if (empty($_SESSION['username']) && empty($_SESSION['password'])) {
    header("Location: index.php?alert=1");
    exit();
} else {
    if ($_GET['act'] == 'insert') {
        if (isset($_POST['Guardar'])) {
            $codigo_transaccion = mysqli_real_escape_string($mysqli, trim($_POST['codigo_transaccion']));
            $fecha = mysqli_real_escape_string($mysqli, trim($_POST['fecha_a']));
            $exp = explode('-', $fecha);
            $fecha_a = $exp[2] . "-" . $exp[1] . "-" . $exp[0];
            $codigo = mysqli_real_escape_string($mysqli, trim($_POST['codigo']));
            $num = mysqli_real_escape_string($mysqli, trim($_POST['num']));
            $observaciones = mysqli_real_escape_string($mysqli, trim($_POST['observaciones']));
            $nombre_entrega = mysqli_real_escape_string($mysqli, trim($_POST['nombre_entrega']));
            $total_stock = mysqli_real_escape_string($mysqli, trim($_POST['total_stock']));
            $tipo_transaccion = mysqli_real_escape_string($mysqli, trim($_POST['transaccion']));
            $created_user = $_SESSION['id_user'];

            // Consulta preparada para evitar inyecciones SQL
            $query = mysqli_prepare($mysqli, "INSERT INTO transaccion_medicamentos(codigo_transaccion, fecha, codigo, numero, created_user, tipo_transaccion, observaciones, nombre_entrega, status) 
                                            VALUES (?, ?, ?, ?, ?, ?, ?, ?, 'A')");

            // Verificar si la consulta preparada fue exitosa
            if ($query) {
                // Asociar parámetros y ejecutar la consulta
                mysqli_stmt_bind_param($query, 'ssssssss', $codigo_transaccion, $fecha_a, $codigo, $num, $created_user, $tipo_transaccion, $observaciones, $nombre_entrega);
                mysqli_stmt_execute($query);

                // Verificar el éxito de la consulta
                if (mysqli_stmt_affected_rows($query) > 0) {
                    // Consulta preparada para actualizar el stock
                    $query1 = mysqli_prepare($mysqli, "UPDATE medicamentos SET stock = ? WHERE codigo = ?");

                    // Verificar si la segunda consulta preparada fue exitosa
                    if ($query1) {
                        // Asociar parámetros y ejecutar la consulta
                        mysqli_stmt_bind_param($query1, 'ss', $total_stock, $codigo);
                        mysqli_stmt_execute($query1);

                        // Verificar el éxito de la segunda consulta
                        if (mysqli_stmt_affected_rows($query1) > 0) {
                            header("Location: ../../../main.php?module=saldo_inicial&alert=1");
                            exit();
                        } else {
                            // Manejar el error en la segunda consulta
                            echo "Error al actualizar el stock.";
                        }

                        // Cerrar la segunda consulta preparada
                        mysqli_stmt_close($query1);
                    } else {
                        // Manejar el error en la segunda consulta preparada
                        echo "Error en la preparación de la consulta para actualizar el stock.";
                    }
                } else {
                    // Manejar el error en la primera consulta
                    echo "Error al insertar la transacción.";
                }

                // Cerrar la consulta preparada
                mysqli_stmt_close($query);
            } else {
                // Manejar el error en la consulta preparada
                echo "Error en la preparación de la consulta.";
            }
        }
    }
}
?>
