-- phpMyAdmin SQL Dump
-- version 4.9.7
-- https://www.phpmyadmin.net/
--
-- Servidor: localhost:3306
-- Tiempo de generación: 06-09-2022 a las 20:58:15
-- Versión del servidor: 5.7.39-cll-lve
-- Versión de PHP: 7.4.30

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de datos: `sanmatespecial_inventariorancho`
--

DELIMITER $$
--
-- Procedimientos
--
CREATE DEFINER=`sanmatespecial`@`localhost` PROCEDURE `stp_kardex` ()  begin
DROP TABLE IF EXISTS saldoinicial_temp;
DROP TABLE IF EXISTS entradas_temp;
DROP TABLE IF EXISTS salidas_temp;

CREATE TEMPORARY TABLE saldoinicial_temp(
    codigo VARCHAR(50) NOT NULL,
    articulo VARCHAR(50) NOT NULL,
    tipo_si DECIMAL(12,2) NOT NULL DEFAULT 0);

CREATE TEMPORARY TABLE entradas_temp(
    codigo VARCHAR(50) NOT NULL,
    articulo VARCHAR(50) NOT NULL,
    tipo_e DECIMAL(12,2) NOT NULL DEFAULT 0);


CREATE TEMPORARY TABLE salidas_temp (
    codigo VARCHAR(50) NOT NULL,
    articulo VARCHAR(50) NOT NULL,
    tipo_s DECIMAL(12,2) NOT NULL DEFAULT 0);


/* Inserta los saldos iniciales */
INSERT INTO saldoinicial_temp
SELECT a.codigo,b.nombre as 'articulo',sum(a.numero) as tipo FROM transaccion_medicamentos as a,medicamentos as b
where tipo_transaccion = 'entrada'
and a.codigo = b.codigo
and a.status = 'A'
and a.observaciones = 'POR INVENTARIO INICIAL'
group by tipo_transaccion,codigo;

/* Inserta Codigo y nombre de Articulo para tener comparacion en caso de que aun no tengamos entradas o salidas diferentes a la de saldo incial*/

INSERT INTO entradas_temp

select codigo as 'codigo',nombre as 'articulo',0 as 'tipo_s' from medicamentos;

INSERT INTO salidas_temp

select codigo as 'codigo',nombre as 'articulo',0 as 'tipo_s' from medicamentos;
 
/* Hace un update a las entradas y salidas que se vayan registrando para cambiar el tipo que es igual a la cantidad que entra o sale*/

update entradas_temp et join 
	(SELECT a.codigo, sum(a.numero) as tipo FROM transaccion_medicamentos as a,medicamentos as b
	where tipo_transaccion = 'Entrada'
	and a.codigo = b.codigo
	and a.status = 'A'
    and a.observaciones <> 'POR INVENTARIO INICIAL'
	group by tipo_transaccion,a.codigo) as x on et.codigo = x.codigo
    set et.tipo_e = x.tipo ;

update salidas_temp es join 
	(SELECT a.codigo, sum(a.numero) as tipo FROM transaccion_medicamentos as a,medicamentos as b
	where tipo_transaccion = 'Salida'
	and a.codigo = b.codigo
	and a.status = 'A'
	group by tipo_transaccion,a.codigo) as x on es.codigo = x.codigo
    set es.tipo_s = x.tipo ;
    
    select 
	a.codigo as 'codigo', 
	a.articulo as 'articulo',
    c.tipo_si as 'saldoinicial',
	a.tipo_e as 'entradas',
	b.tipo_s as 'salidas',
	((c.tipo_si + a.Tipo_e) - b.Tipo_s) as 'existencia'
	FROM entradas_temp as a, salidas_temp as b, saldoinicial_temp as c
	where a.codigo = b.codigo
	 and  a.codigo = c.codigo
	order by b.tipo_s desc;


end$$

CREATE DEFINER=`sanmatespecial`@`localhost` PROCEDURE `stp_stock` ()  begin
DROP TABLE IF EXISTS saldoinicial_temp;
DROP TABLE IF EXISTS entradas_temp;
DROP TABLE IF EXISTS salidas_temp;

CREATE TEMPORARY TABLE saldoinicial_temp(
    codigo VARCHAR(50) NOT NULL,
    articulo VARCHAR(50) NOT NULL,
    tipo_si DECIMAL(12,2) NOT NULL DEFAULT 0);

CREATE TEMPORARY TABLE entradas_temp(
    codigo VARCHAR(50) NOT NULL,
    articulo VARCHAR(50) NOT NULL,
    tipo_e DECIMAL(12,2) NOT NULL DEFAULT 0);


CREATE TEMPORARY TABLE salidas_temp (
    codigo VARCHAR(50) NOT NULL,
    articulo VARCHAR(50) NOT NULL,
    tipo_s DECIMAL(12,2) NOT NULL DEFAULT 0);


/* Inserta los saldos iniciales */
INSERT INTO saldoinicial_temp
SELECT a.codigo,b.nombre as 'articulo',sum(a.numero) as tipo FROM transaccion_medicamentos as a,medicamentos as b
where tipo_transaccion = 'entrada'
and a.codigo = b.codigo
and a.status = 'A'
and a.observaciones = 'POR INVENTARIO INICIAL'
group by tipo_transaccion,codigo;

/* Inserta Codigo y nombre de Articulo para tener comparacion en caso de que aun no tengamos entradas o salidas diferentes a la de saldo incial*/

INSERT INTO entradas_temp

select codigo as 'codigo',nombre as 'articulo',0 as 'tipo_s' from medicamentos;

INSERT INTO salidas_temp

select codigo as 'codigo',nombre as 'articulo',0 as 'tipo_s' from medicamentos;
 
/* Hace un update a las entradas y salidas que se vayan registrando para cambiar el tipo que es igual a la cantidad que entra o sale*/

update entradas_temp et join 
	(SELECT a.codigo, sum(a.numero) as tipo FROM transaccion_medicamentos as a,medicamentos as b
	where tipo_transaccion = 'Entrada'
	and a.codigo = b.codigo
	and a.status = 'A'
    and a.observaciones <> 'POR INVENTARIO INICIAL'
	group by tipo_transaccion,a.codigo) as x on et.codigo = x.codigo
    set et.tipo_e = x.tipo ;

update salidas_temp es join 
	(SELECT a.codigo, sum(a.numero) as tipo FROM transaccion_medicamentos as a,medicamentos as b
	where tipo_transaccion = 'Salida'
	and a.codigo = b.codigo
	and a.status = 'A'
	group by tipo_transaccion,a.codigo) as x on es.codigo = x.codigo
    set es.tipo_s = x.tipo ;
    
    select 
	a.codigo as 'codigo', 
	a.articulo as 'articulo',
    c.tipo_si as 'saldoinicial',
	a.tipo_e as 'entradas',
	b.tipo_s as 'salidas',
	((c.tipo_si + a.Tipo_e) - b.Tipo_s) as 'existencia'
	FROM entradas_temp as a, salidas_temp as b, saldoinicial_temp as c
	where a.codigo = b.codigo
	 and  a.codigo = c.codigo
	order by b.tipo_s desc;


end$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `apertura_cierre`
--

CREATE TABLE `apertura_cierre` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `nombre` varchar(150) DEFAULT NULL,
  `apertura` varchar(10) NOT NULL,
  `cierre` int(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `apertura_cierre`
--

INSERT INTO `apertura_cierre` (`id`, `nombre`, `apertura`, `cierre`) VALUES
(1, 'INVENTARIO ALMACEN MERCADOTECNIA', 'ABIERTO', 0);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `condiciones_cierre`
--

CREATE TABLE `condiciones_cierre` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(150) DEFAULT NULL,
  `tipo` int(1) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `condiciones_cierre`
--

INSERT INTO `condiciones_cierre` (`id`, `name`, `tipo`) VALUES
(1, 'CERRADO', 1),
(2, 'ABIERTO', 0);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `correos`
--

CREATE TABLE `correos` (
  `id` int(11) NOT NULL,
  `nombre` varchar(255) DEFAULT NULL,
  `tipo` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `correos`
--

INSERT INTO `correos` (`id`, `nombre`, `tipo`) VALUES
(1, 'JOSE LUIS ROBLES', 'jrobles@sanmatias.com'),
(2, 'JAVIER LOPEZ', 'flopez@sanmatias.com'),
(3, 'ANGEL PARRA', 'jparra@sanmatias.mx'),
(11, 'JAVIER LOPEZ PERSONAL', 'jjavierlopez14@gmail.com');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `envio`
--

CREATE TABLE `envio` (
  `id` int(11) NOT NULL,
  `host` varchar(100) DEFAULT NULL,
  `port` varchar(4) DEFAULT NULL,
  `nombre` varchar(100) NOT NULL,
  `usuario` varchar(100) DEFAULT NULL,
  `password` varchar(15) DEFAULT NULL,
  `setname` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `envio`
--

INSERT INTO `envio` (`id`, `host`, `port`, `nombre`, `usuario`, `password`, `setname`) VALUES
(1, 'mail.sanmatias.mx', '587', 'Envio de correo Inventarios MKT', 'inventarios@sanmatias.mx', 'P@88w0rd.0', 'Notificaciones Inventario MKT');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `medicamentos`
--

CREATE TABLE `medicamentos` (
  `codigo` varchar(10) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  `precio_compra` float(11,2) NOT NULL,
  `precio_venta` double NOT NULL,
  `unidad` varchar(20) NOT NULL,
  `stock` int(11) NOT NULL,
  `created_user` int(3) NOT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_user` int(3) NOT NULL,
  `updated_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `precio_compra2` varchar(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `motivo`
--

CREATE TABLE `motivo` (
  `id` int(11) NOT NULL,
  `nombre` varchar(255) DEFAULT NULL,
  `tipo` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `motivo`
--

INSERT INTO `motivo` (`id`, `nombre`, `tipo`) VALUES
(1, 'POR INVENTARIO INICIAL', 'ENTRADA'),
(2, 'ABASTECER CODIGO', 'ENTRADA'),
(3, 'DEGUSTACION', 'SALIDA'),
(4, 'DEGUSTACION  EVENTO', 'SALIDA'),
(5, 'BONIFICACION 1', 'SALIDA'),
(6, 'BONIFICACION', 'SALIDA'),
(7, 'PATROCINIO', 'SALIDA'),
(8, 'PATROCINIO EVENTO', 'SALIDA'),
(9, 'PATROCINIO', 'SALIDA'),
(10, 'OBSEQUIO', 'SALIDA'),
(11, 'CAMBIO FISICO', 'SALIDA'),
(12, 'PUBLICIDAD', 'SALIDA'),
(13, 'INTERCAMBIO', 'SALIDA'),
(14, 'SEMBRADO', 'SALIDA'),
(15, 'CONCURSO', 'SALIDA'),
(16, 'MUESTRAS', 'SALIDA'),
(17, 'PRESTAMO', 'SALIDA'),
(18, 'EXPO', 'SALIDA'),
(19, 'PROMOCION PUNTUAL', 'SALIDA'),
(20, 'ACTIVACION', 'SALIDA'),
(21, 'PLAN LEALTAD', 'SALIDA');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `parametro_correos`
--

CREATE TABLE `parametro_correos` (
  `id` int(11) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  `cc1` varchar(50) NOT NULL,
  `cc2` varchar(50) NOT NULL,
  `cc3` varchar(50) NOT NULL,
  `cc4` varchar(50) NOT NULL,
  `cc5` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `parametro_correos`
--

INSERT INTO `parametro_correos` (`id`, `nombre`, `cc1`, `cc2`, `cc3`, `cc4`, `cc5`) VALUES
(1, 'Entradas de almacen', 'flopez@sanmatias.com', 'jramos@sanmatias.mx', 'iortiz@sanmatias.com', '', ''),
(2, 'Salidas de almacen', 'iortiz@sanmatias.com', 'jramos@sanmatias.mx', 'flopez@sanmatias.com', '', ''),
(3, 'Remisiones', 'iortiz@sanmatias.com', 'jramos@sanmatias.mx', '', '', '');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `perfil`
--

CREATE TABLE `perfil` (
  `id` int(11) NOT NULL,
  `nombre_empresa` varchar(150) NOT NULL,
  `direccion` varchar(255) NOT NULL,
  `email` varchar(64) NOT NULL,
  `folio` varchar(64) NOT NULL,
  `almacen` varchar(64) NOT NULL,
  `almacenista` varchar(64) NOT NULL,
  `folio2` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `perfil`
--

INSERT INTO `perfil` (`id`, `nombre_empresa`, `direccion`, `email`, `folio`, `almacen`, `almacenista`, `folio2`) VALUES
(1, 'Casa San Matias', 'Av. Circ. Agustin YaÃ±ez # 2612', 'flopez@sanmatias.com', 'RAN', 'RANCHO', 'ANGEL PARRA', 'REM_RAN');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `remision_detalle`
--

CREATE TABLE `remision_detalle` (
  `id` int(11) NOT NULL,
  `fecha` date NOT NULL,
  `codigo` varchar(7) NOT NULL,
  `cantidad` int(11) NOT NULL,
  `created_user` int(3) NOT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `tipo_transaccion` varchar(50) NOT NULL,
  `observaciones` varchar(500) NOT NULL,
  `idenc` int(11) DEFAULT NULL,
  `status` varchar(1) DEFAULT NULL,
  `transito` varchar(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `remision_encabezado`
--

CREATE TABLE `remision_encabezado` (
  `id` int(11) NOT NULL,
  `serie` varchar(15) NOT NULL DEFAULT 'REM-',
  `folio` int(11) NOT NULL,
  `fecha` date NOT NULL,
  `created_user` int(3) NOT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `nombre` varchar(150) NOT NULL,
  `status` varchar(1) NOT NULL,
  `observacion_enc` varchar(100) NOT NULL,
  `idSalida` int(11) DEFAULT NULL,
  `txtCorreo` varchar(50) NOT NULL,
  `txtCancel` varchar(200) NOT NULL,
  `txtMotivo` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `transaccion_medicamentos`
--

CREATE TABLE `transaccion_medicamentos` (
  `codigo_transaccion` varchar(15) NOT NULL,
  `fecha` date NOT NULL,
  `codigo` varchar(7) NOT NULL,
  `numero` int(11) NOT NULL,
  `created_user` int(3) NOT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `tipo_transaccion` varchar(50) NOT NULL,
  `observaciones` varchar(500) NOT NULL,
  `area` varchar(50) NOT NULL,
  `nombre_entrega` varchar(50) NOT NULL,
  `idenc` int(11) DEFAULT NULL,
  `status` varchar(1) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `transaccion_medicamentos_enc`
--

CREATE TABLE `transaccion_medicamentos_enc` (
  `id` int(11) NOT NULL,
  `serie` varchar(15) NOT NULL DEFAULT 'TRADE-',
  `folio` int(11) NOT NULL,
  `fecha` date NOT NULL,
  `created_user` int(3) NOT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `nombre` varchar(150) NOT NULL,
  `status` varchar(1) NOT NULL,
  `observacion_enc` varchar(100) NOT NULL,
  `txtCorreo` varchar(50) NOT NULL,
  `txtCancel` varchar(200) DEFAULT NULL,
  `txtMotivo` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `unidades`
--

CREATE TABLE `unidades` (
  `id` int(11) NOT NULL,
  `nombre` varchar(255) DEFAULT NULL,
  `tipo` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `unidades`
--

INSERT INTO `unidades` (`id`, `nombre`, `tipo`) VALUES
(1, 'PIEZAS', 'PZ'),
(2, 'BOTELLA', 'BT'),
(3, 'CAJA', 'CJ');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `usuarios`
--

CREATE TABLE `usuarios` (
  `id_user` int(3) NOT NULL,
  `username` varchar(50) NOT NULL,
  `name_user` varchar(50) NOT NULL,
  `password` varchar(50) NOT NULL,
  `email` varchar(50) DEFAULT NULL,
  `telefono` varchar(13) DEFAULT NULL,
  `foto` varchar(100) DEFAULT NULL,
  `permisos_acceso` enum('root','Admin','Almacenista','Supervisor') NOT NULL,
  `status` enum('activo','bloqueado') NOT NULL DEFAULT 'activo',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `usuarios`
--

INSERT INTO `usuarios` (`id_user`, `username`, `name_user`, `password`, `email`, `telefono`, `foto`, `permisos_acceso`, `status`, `created_at`, `updated_at`) VALUES
(1, 'admin', 'Sistemas', '713a20ec335220f0c695b6a23c3a4fd6', 'jrobles@sanmatias.com', '3316994062', 'WIN_20201015_14_38_09_Pro.jpg', 'Admin', 'activo', '2017-04-01 08:15:15', '2021-06-22 15:59:43'),
(3, 'jrobles', 'Jose Luis Robles', '69d0cbf2711c14dbe610b4cb3b17c868', '', '', 'JL.jpg', 'root', 'activo', '2018-08-09 01:08:01', '2021-06-22 17:20:42'),
(4, 'flopez', 'Francisco Javier Lopez', '5d76fd2aae18cf31335c312a93fe2c87', '', '', 'flopez.jpg', 'Admin', 'activo', '2018-08-09 01:10:27', '2021-07-05 20:36:37'),
(8, 'jramos', 'Jose Ramos', '9db9cfe082f77f246df56f5ff57984be', '', '', 'JR.jpg', 'Almacenista', 'activo', '2018-08-10 04:45:40', '2021-07-27 04:18:27');

--
-- Índices para tablas volcadas
--

--
-- Indices de la tabla `apertura_cierre`
--
ALTER TABLE `apertura_cierre`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `condiciones_cierre`
--
ALTER TABLE `condiciones_cierre`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `correos`
--
ALTER TABLE `correos`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `envio`
--
ALTER TABLE `envio`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `medicamentos`
--
ALTER TABLE `medicamentos`
  ADD PRIMARY KEY (`codigo`),
  ADD KEY `created_user` (`created_user`),
  ADD KEY `updated_user` (`updated_user`);

--
-- Indices de la tabla `motivo`
--
ALTER TABLE `motivo`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `parametro_correos`
--
ALTER TABLE `parametro_correos`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `perfil`
--
ALTER TABLE `perfil`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `remision_detalle`
--
ALTER TABLE `remision_detalle`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id_barang` (`codigo`),
  ADD KEY `created_user` (`created_user`);

--
-- Indices de la tabla `remision_encabezado`
--
ALTER TABLE `remision_encabezado`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_user` (`created_user`),
  ADD KEY `remision_encabezado_sal` (`idSalida`);

--
-- Indices de la tabla `transaccion_medicamentos`
--
ALTER TABLE `transaccion_medicamentos`
  ADD PRIMARY KEY (`codigo_transaccion`),
  ADD KEY `id_barang` (`codigo`),
  ADD KEY `created_user` (`created_user`);

--
-- Indices de la tabla `transaccion_medicamentos_enc`
--
ALTER TABLE `transaccion_medicamentos_enc`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_user` (`created_user`);

--
-- Indices de la tabla `unidades`
--
ALTER TABLE `unidades`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `usuarios`
--
ALTER TABLE `usuarios`
  ADD PRIMARY KEY (`id_user`),
  ADD KEY `level` (`permisos_acceso`);

--
-- AUTO_INCREMENT de las tablas volcadas
--

--
-- AUTO_INCREMENT de la tabla `apertura_cierre`
--
ALTER TABLE `apertura_cierre`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de la tabla `condiciones_cierre`
--
ALTER TABLE `condiciones_cierre`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT de la tabla `correos`
--
ALTER TABLE `correos`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;

--
-- AUTO_INCREMENT de la tabla `envio`
--
ALTER TABLE `envio`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de la tabla `motivo`
--
ALTER TABLE `motivo`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=22;

--
-- AUTO_INCREMENT de la tabla `perfil`
--
ALTER TABLE `perfil`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de la tabla `remision_detalle`
--
ALTER TABLE `remision_detalle`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=190;

--
-- AUTO_INCREMENT de la tabla `remision_encabezado`
--
ALTER TABLE `remision_encabezado`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `transaccion_medicamentos_enc`
--
ALTER TABLE `transaccion_medicamentos_enc`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `unidades`
--
ALTER TABLE `unidades`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT de la tabla `usuarios`
--
ALTER TABLE `usuarios`
  MODIFY `id_user` int(3) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- Restricciones para tablas volcadas
--

--
-- Filtros para la tabla `medicamentos`
--
ALTER TABLE `medicamentos`
  ADD CONSTRAINT `medicamentos_ibfk_1` FOREIGN KEY (`created_user`) REFERENCES `usuarios` (`id_user`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `medicamentos_ibfk_2` FOREIGN KEY (`updated_user`) REFERENCES `usuarios` (`id_user`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `remision_detalle`
--
ALTER TABLE `remision_detalle`
  ADD CONSTRAINT `remision_detalle_ibfk_1` FOREIGN KEY (`codigo`) REFERENCES `medicamentos` (`codigo`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `remision_detalle_ibfk_2` FOREIGN KEY (`created_user`) REFERENCES `usuarios` (`id_user`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `remision_encabezado`
--
ALTER TABLE `remision_encabezado`
  ADD CONSTRAINT `remision_encabezado_sal` FOREIGN KEY (`idSalida`) REFERENCES `transaccion_medicamentos_enc` (`id`);

--
-- Filtros para la tabla `transaccion_medicamentos`
--
ALTER TABLE `transaccion_medicamentos`
  ADD CONSTRAINT `transaccion_medicamentos_ibfk_1` FOREIGN KEY (`codigo`) REFERENCES `medicamentos` (`codigo`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `transaccion_medicamentos_ibfk_2` FOREIGN KEY (`created_user`) REFERENCES `usuarios` (`id_user`) ON DELETE CASCADE ON UPDATE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
